/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.util;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public final class PathPrettyPrinting {
    private static final Comparator<PathSubstitution> SUBSTITUTION_COMPARATOR = Comparator.comparingInt(alias -> alias.basePath.getNameCount()).reversed();
    private static volatile List<PathSubstitution> SUBSTITUTIONS = new ArrayList<PathSubstitution>();

    private PathPrettyPrinting() {
    }

    public static void addRoot(Path root) {
        PathPrettyPrinting.addSubstitution(root, "", "");
    }

    public static void addSubstitution(Path root, String prefix, String suffix) {
        ArrayList<PathSubstitution> newSubstitutions = new ArrayList<PathSubstitution>(SUBSTITUTIONS);
        newSubstitutions.add(new PathSubstitution(root, prefix, suffix));
        newSubstitutions.sort(SUBSTITUTION_COMPARATOR);
        SUBSTITUTIONS = newSubstitutions;
    }

    public static String prettyPrint(Path path) {
        Object resultPath = null;
        List<PathSubstitution> currentSubstitutions = SUBSTITUTIONS;
        for (PathSubstitution substitution : currentSubstitutions) {
            if (!path.startsWith(substitution.basePath)) continue;
            resultPath = substitution.prefix + String.valueOf(substitution.basePath.relativize(path)) + substitution.suffix;
            break;
        }
        if (resultPath == null) {
            resultPath = Files.isDirectory(path, new LinkOption[0]) ? path.toAbsolutePath().toString() : path.toString();
        }
        resultPath = ((String)resultPath).replace('\\', '/');
        return resultPath;
    }

    private record PathSubstitution(Path basePath, String prefix, String suffix) {
    }
}

