/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.startup;

import java.lang.invoke.MethodHandle;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.startup.Entrypoint;
import net.neoforged.fml.startup.FatalErrorReporting;
import net.neoforged.fml.startup.FatalStartupException;

public class Server
extends Entrypoint {
    private Server() {
    }

    public static void main(String[] args) {
        try (FMLLoader loader = Server.startup(args, true, Dist.DEDICATED_SERVER, true);){
            MethodHandle main = Server.createMainMethodCallable(loader, "net.minecraft.server.Main");
            main.invokeExact(loader.getProgramArgs().getArguments());
            Thread serverThread = Server.findThread("Server thread");
            if (serverThread == null) {
                throw new FatalStartupException("Couldn't find Minecraft server thread. Startup likely failed.");
            }
            serverThread.join();
        }
        catch (Throwable t) {
            FatalErrorReporting.reportFatalErrorOnConsole(t);
            System.exit(1);
        }
    }
}

