/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.startup;

import com.sun.tools.attach.VirtualMachine;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import net.neoforged.fml.startup.DevAgent;
import net.neoforged.fml.util.ClasspathResourceUtils;

public class SelfAttach {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        String parentExecutable;
        String ourExecutable;
        ProcessHandle parentProcess = ProcessHandle.current().parent().orElse(null);
        if (parentProcess == null) {
            System.err.println("No parent process to attach to");
            System.exit(1);
        }
        if (!Objects.equals(ourExecutable = (String)parentProcess.info().command().orElse(null), parentExecutable = (String)parentProcess.info().command().orElse(null))) {
            System.err.println("Can only self-attach if the processes match: " + ourExecutable + " != " + parentExecutable);
            System.exit(1);
        }
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().putValue("Manifest-Version", "1.0");
        manifest.getMainAttributes().putValue("Agent-Class", DevAgent.class.getName());
        Path tempFile = null;
        VirtualMachine vm = null;
        try {
            tempFile = Files.createTempFile("agentattach", ".jar", new FileAttribute[0]);
            new JarOutputStream(Files.newOutputStream(tempFile, new OpenOption[0]), manifest).close();
            vm = VirtualMachine.attach(String.valueOf(parentProcess.pid()));
            vm.loadAgent(tempFile.toAbsolutePath().toString());
        }
        finally {
            if (vm != null) {
                vm.detach();
            }
            if (tempFile != null) {
                Files.deleteIfExists(tempFile);
            }
        }
    }

    public static String getClassPathItem() {
        String relativeClassPath = SelfAttach.class.getName().replace('.', '/') + ".class";
        Path classPathItem = ClasspathResourceUtils.findFileSystemRootOfFileOnClasspath(SelfAttach.class.getClassLoader(), relativeClassPath);
        if (classPathItem == null) {
            throw new IllegalStateException("Failed to find SelfAttach class file on classpath");
        }
        return classPathItem.toAbsolutePath().toString();
    }
}

