/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.startup;

import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BaseMultiResolutionImage;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import net.neoforged.fml.startup.FatalStartupException;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

public final class FatalErrorReporting {
    private FatalErrorReporting() {
    }

    private static Throwable unwrapException(Throwable t) {
        if (t == null) {
            return null;
        }
        Throwable cause = t.getCause();
        if (cause == null) {
            return t;
        }
        if (t instanceof InvocationTargetException) {
            return cause;
        }
        return t;
    }

    public static void reportFatalError(Throwable t) {
        if ((t = FatalErrorReporting.unwrapException(t)) instanceof FatalStartupException) {
            FatalStartupException e = (FatalStartupException)t;
            StringBuilder errorText = new StringBuilder(e.getMessage());
            if (e.getCause() != null) {
                errorText.append("\n\nTechnical Details:\n");
                FatalErrorReporting.appendAbbreviatedExceptionChain(FatalErrorReporting.unwrapException(e.getCause()), errorText);
            }
            FatalErrorReporting.reportFatalError(errorText.toString());
        } else {
            StringBuilder exceptionText = new StringBuilder();
            exceptionText.append("An uncaught technical error occurred:\n");
            FatalErrorReporting.appendAbbreviatedExceptionChain(t, exceptionText);
            FatalErrorReporting.reportFatalError(exceptionText.toString());
        }
    }

    private static void appendAbbreviatedExceptionChain(Throwable t, StringBuilder exceptionText) {
        boolean first = true;
        while (t != null) {
            if (first) {
                exceptionText.append("  ").append(t).append('\n');
                first = false;
            } else {
                exceptionText.append(" \u21b3").append(t).append('\n');
            }
            t = FatalErrorReporting.unwrapException(t.getCause());
        }
    }

    public static void reportFatalErrorOnConsole(Throwable t) {
        t = FatalErrorReporting.unwrapException(t);
        t.printStackTrace();
    }

    public static void reportFatalError(String message) {
        System.setProperty("java.awt.headless", "false");
        if (!GraphicsEnvironment.isHeadless()) {
            FatalErrorReporting.showErrorUsingSwing(message);
        } else {
            message = message.replace('\"', '`');
            message = message.replace('\'', '`');
            TinyFileDialogs.tinyfd_messageBox((CharSequence)"NeoForge - Fatal Startup Error", (CharSequence)message, (CharSequence)"ok", (CharSequence)"error", (boolean)false);
        }
        System.exit(1);
    }

    private static void showErrorUsingSwing(String message) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object html = "<html><body width='400'><strong>Fatal Startup Error</strong><p><pre>";
        html = (String)html + FatalErrorReporting.escapeHtmlContent(message);
        ImageIcon icon = new ImageIcon(FatalErrorReporting.createMultiResImage());
        JOptionPane.showMessageDialog(null, html, "Fatal Error", 0, icon);
    }

    private static BaseMultiResolutionImage createMultiResImage() {
        ArrayList<Image> images = new ArrayList<Image>();
        FatalErrorReporting.readImage("crash-32x32.png", images);
        FatalErrorReporting.readImage("crash-64x64.png", images);
        FatalErrorReporting.readImage("crash-128x128.png", images);
        return new BaseMultiResolutionImage((Image[])images.toArray(Image[]::new));
    }

    private static void readImage(String filename, List<Image> images) {
        try {
            BufferedImage image = ImageIO.read(FatalErrorReporting.class.getResource(filename));
            images.add(image);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static String escapeHtmlContent(String content) {
        return content.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&#x27;");
    }
}

