/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading.moddiscovery.locators;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.neoforged.fml.ModLoadingIssue;
import net.neoforged.fml.jarcontents.JarContents;
import net.neoforged.fml.loading.LogMarkers;
import net.neoforged.neoforgespi.ILaunchContext;
import net.neoforged.neoforgespi.locating.IDiscoveryPipeline;
import net.neoforged.neoforgespi.locating.IModFileCandidateLocator;
import net.neoforged.neoforgespi.locating.IncompatibleFileReporting;
import net.neoforged.neoforgespi.locating.ModFileDiscoveryAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InDevFolderLocator
implements IModFileCandidateLocator {
    private static final Logger LOGGER = LoggerFactory.getLogger(InDevFolderLocator.class);
    private final Map<File, VirtualJarManifestEntry> virtualJarMemberIndex = new HashMap<File, VirtualJarManifestEntry>();

    @Override
    public void findCandidates(ILaunchContext context, IDiscoveryPipeline pipeline) {
        this.loadFromSystemProperty();
        for (VirtualJarManifestEntry entry : new HashSet<VirtualJarManifestEntry>(this.virtualJarMemberIndex.values())) {
            List<Path> paths = entry.files.stream().map(File::toPath).toList();
            if (!paths.stream().noneMatch(context::isLocated)) continue;
            try {
                pipeline.addJarContent(JarContents.ofPaths(paths), ModFileDiscoveryAttributes.DEFAULT, IncompatibleFileReporting.ERROR);
            }
            catch (IOException e) {
                pipeline.addIssue(ModLoadingIssue.error("fml.modloadingissue.brokenfile.invalidzip", new Object[0]).withAffectedPath(paths.getFirst()).withCause(e));
            }
        }
    }

    private void loadFromSystemProperty() {
        String modFolders = Optional.ofNullable(System.getenv("MOD_CLASSES")).orElse(System.getProperty("fml.modFolders", ""));
        if (!modFolders.isEmpty()) {
            LOGGER.info(LogMarkers.CORE, "Got mod coordinates {} from env", (Object)modFolders);
            Map groupedEntries = Arrays.stream(modFolders.split(File.pathSeparator)).collect(Collectors.groupingBy(inp -> {
                int splitIdx = inp.indexOf("%%");
                if (splitIdx != -1) {
                    return inp.substring(0, splitIdx);
                }
                return "defaultmodid";
            }, Collectors.mapping(inp -> {
                int splitIdx = inp.indexOf("%%");
                if (splitIdx != -1) {
                    inp = inp.substring(splitIdx + "%%".length());
                }
                return new File((String)inp);
            }, Collectors.toList())));
            for (Map.Entry group : groupedEntries.entrySet()) {
                VirtualJarManifestEntry virtualJar = new VirtualJarManifestEntry(group.getKey(), group.getValue());
                for (File file : group.getValue()) {
                    this.virtualJarMemberIndex.put(file, virtualJar);
                }
            }
        }
    }

    @Override
    public int getPriority() {
        return 1000;
    }

    public String toString() {
        return "indevfolder";
    }

    record VirtualJarManifestEntry(String name, List<File> files) {
    }
}

