/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading.moddiscovery.locators;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Stream;
import net.neoforged.fml.ModLoadingException;
import net.neoforged.fml.ModLoadingIssue;
import net.neoforged.fml.jarcontents.JarContents;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.fml.loading.LogMarkers;
import net.neoforged.fml.loading.StringUtils;
import net.neoforged.fml.loading.echosky.ModDecryptor;
import net.neoforged.neoforgespi.ILaunchContext;
import net.neoforged.neoforgespi.locating.IDiscoveryPipeline;
import net.neoforged.neoforgespi.locating.IModFileCandidateLocator;
import net.neoforged.neoforgespi.locating.IncompatibleFileReporting;
import net.neoforged.neoforgespi.locating.ModFileDiscoveryAttributes;
import org.slf4j.Logger;

public class EchoSkyModLocator
implements IModFileCandidateLocator {
    private static final String SUFFIX = ".echomod";
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Path echoSkyFolder = FMLPaths.GAMEDIR.get().resolve("mods");

    @Override
    public void findCandidates(ILaunchContext context, IDiscoveryPipeline pipeline) {
        List<Path> encryptedMods;
        if (!Files.exists(this.echoSkyFolder, new LinkOption[0])) {
            LOGGER.debug(LogMarkers.SCAN, "EchoSky mods folder {} does not exist, skipping", (Object)this.echoSkyFolder);
            return;
        }
        LOGGER.info(LogMarkers.SCAN, "[EchoSky] Scanning {} for encrypted mods", (Object)this.echoSkyFolder);
        try (Stream<Path> files = Files.list(this.echoSkyFolder);){
            encryptedMods = files.filter(p -> StringUtils.toLowerCase(p.getFileName().toString()).endsWith(SUFFIX)).sorted(Comparator.comparing(path -> StringUtils.toLowerCase(path.getFileName().toString()))).toList();
        }
        catch (IOException e) {
            throw new ModLoadingException(ModLoadingIssue.error("fml.modloadingissue.failed_to_list_folder_content", this.echoSkyFolder).withAffectedPath(this.echoSkyFolder).withCause(e));
        }
        LOGGER.info(LogMarkers.SCAN, "[EchoSky] Found {} encrypted mod(s)", (Object)encryptedMods.size());
        for (Path encryptedFile : encryptedMods) {
            try {
                this.loadEncryptedMod(encryptedFile, pipeline);
            }
            catch (Exception e) {
                LOGGER.error(LogMarkers.SCAN, "[EchoSky] Failed to load encrypted mod: {}", (Object)encryptedFile, (Object)e);
                pipeline.addIssue(ModLoadingIssue.error("fml.modloadingissue.brokenfile", new Object[0]).withAffectedPath(encryptedFile).withCause(e));
            }
        }
    }

    private void loadEncryptedMod(Path encryptedFile, IDiscoveryPipeline pipeline) throws IOException {
        LOGGER.debug(LogMarkers.SCAN, "[EchoSky] Decrypting mod: {}", (Object)encryptedFile);
        byte[] encryptedData = Files.readAllBytes(encryptedFile);
        byte[] decryptedJar = ModDecryptor.decryptMod(encryptedData);
        if (decryptedJar == null || decryptedJar.length == 0) {
            throw new IOException("Decryption failed or returned empty data");
        }
        LOGGER.info(LogMarkers.SCAN, "[EchoSky] Successfully decrypted {} ({} bytes)", (Object)encryptedFile.getFileName(), (Object)decryptedJar.length);
        Path inMemoryJarPath = this.createInMemoryJar(encryptedFile.getFileName().toString(), decryptedJar);
        JarContents jarContents = JarContents.ofPath(inMemoryJarPath);
        pipeline.addJarContent(jarContents, ModFileDiscoveryAttributes.DEFAULT, IncompatibleFileReporting.WARN_ALWAYS);
    }

    private Path createInMemoryJar(String fileName, byte[] jarBytes) throws IOException {
        String uniqueId = "echosky_" + System.nanoTime();
        URI uri = URI.create("jar:file:/mem/" + uniqueId + "/" + fileName);
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("create", "true");
        Path tempPath = this.createTempInMemoryPath(fileName);
        Files.write(tempPath, jarBytes, new OpenOption[0]);
        LOGGER.debug("[EchoSky] Created in-memory JAR at: {}", (Object)tempPath);
        return tempPath;
    }

    private Path createTempInMemoryPath(String fileName) throws IOException {
        Path memPath = Path.of("/dev/shm", new String[0]);
        if (Files.exists(memPath, new LinkOption[0]) && Files.isWritable(memPath)) {
            Path tempFile = memPath.resolve("echosky_" + System.nanoTime() + "_" + fileName);
            tempFile.toFile().deleteOnExit();
            return tempFile;
        }
        Path tempFile = Files.createTempFile("echosky_", "_" + fileName, new FileAttribute[0]);
        tempFile.toFile().deleteOnExit();
        LOGGER.warn("[EchoSky] Using disk-based temp file (tmpfs not available): {}", (Object)tempFile);
        return tempFile;
    }

    public String toString() {
        return "{EchoSky encrypted mods locator at " + String.valueOf(this.echoSkyFolder) + "}";
    }
}

