/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading.mixin;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.mixin.FMLAuditTrail;
import net.neoforged.fml.loading.mixin.FMLClassProvider;
import net.neoforged.fml.loading.mixin.FMLClassTracker;
import net.neoforged.fml.loading.mixin.FMLMixinLogger;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.spongepowered.asm.launch.platform.container.ContainerHandleVirtual;
import org.spongepowered.asm.launch.platform.container.IContainerHandle;
import org.spongepowered.asm.logging.ILogger;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.transformer.IMixinTransformer;
import org.spongepowered.asm.mixin.transformer.IMixinTransformerFactory;
import org.spongepowered.asm.service.IClassBytecodeProvider;
import org.spongepowered.asm.service.IClassProvider;
import org.spongepowered.asm.service.IClassTracker;
import org.spongepowered.asm.service.IMixinAuditTrail;
import org.spongepowered.asm.service.IMixinInternal;
import org.spongepowered.asm.service.IMixinService;
import org.spongepowered.asm.service.ITransformerProvider;
import org.spongepowered.asm.util.ReEntranceLock;

public class FMLMixinService
implements IMixinService {
    private final ConcurrentHashMap<String, FMLMixinLogger> loggers = new ConcurrentHashMap();
    private final ReEntranceLock lock = new ReEntranceLock(1);
    private IClassProvider classProvider;
    @Nullable
    private IClassBytecodeProvider bytecodeProvider;
    private final FMLClassTracker classTracker = new FMLClassTracker();
    private final FMLAuditTrail auditTrail = new FMLAuditTrail();
    private final Map<String, byte[]> mixinConfigContents = new HashMap<String, byte[]>();
    @Nullable
    private IMixinTransformer mixinTransformer;
    private final ContainerHandleVirtual primaryContainer = new ContainerHandleVirtual("fml");
    private final List<IContainerHandle> mixinContainers = new ArrayList<IContainerHandle>();

    public void prepare() {
    }

    public MixinEnvironment.Phase getInitialPhase() {
        return MixinEnvironment.Phase.PREINIT;
    }

    public void init() {
    }

    public void beginPhase() {
    }

    public void checkEnv(Object bootSource) {
    }

    public ReEntranceLock getReEntranceLock() {
        return this.lock;
    }

    public String getSideName() {
        return switch (FMLLoader.getCurrent().getDist()) {
            default -> throw new MatchException(null, null);
            case Dist.CLIENT -> "CLIENT";
            case Dist.DEDICATED_SERVER -> "SERVER";
        };
    }

    public void setBytecodeProvider(@Nullable IClassBytecodeProvider bytecodeProvider) {
        this.bytecodeProvider = bytecodeProvider;
    }

    public void offer(IMixinInternal internal) {
        if (internal instanceof IMixinTransformerFactory) {
            IMixinTransformerFactory mixinTransformerFactory = (IMixinTransformerFactory)internal;
            this.mixinTransformer = mixinTransformerFactory.createTransformer();
        }
    }

    public String getName() {
        return "FML";
    }

    public MixinEnvironment.CompatibilityLevel getMinCompatibilityLevel() {
        return MixinEnvironment.CompatibilityLevel.JAVA_21;
    }

    public MixinEnvironment.CompatibilityLevel getMaxCompatibilityLevel() {
        return null;
    }

    public ILogger getLogger(String name) {
        return this.loggers.computeIfAbsent(name, FMLMixinLogger::new);
    }

    public boolean isValid() {
        return true;
    }

    public IClassProvider getClassProvider() {
        if (this.classProvider == null) {
            this.classProvider = new FMLClassProvider();
        }
        return this.classProvider;
    }

    public IClassBytecodeProvider getBytecodeProvider() {
        if (this.bytecodeProvider == null) {
            throw new IllegalStateException("Service initialisation incomplete, launch plugin was not created");
        }
        return this.bytecodeProvider;
    }

    public ITransformerProvider getTransformerProvider() {
        return null;
    }

    public IClassTracker getClassTracker() {
        return this.classTracker;
    }

    FMLClassTracker getInternalClassTracker() {
        return this.classTracker;
    }

    public IMixinAuditTrail getAuditTrail() {
        return this.auditTrail;
    }

    FMLAuditTrail getInternalAuditTrail() {
        return this.auditTrail;
    }

    public IMixinTransformer getMixinTransformer() {
        return Objects.requireNonNull(this.mixinTransformer);
    }

    public Collection<String> getPlatformAgents() {
        return List.of("org.spongepowered.asm.launch.platform.MixinPlatformAgentDefault");
    }

    public IContainerHandle getPrimaryContainer() {
        return this.primaryContainer;
    }

    public Collection<IContainerHandle> getMixinContainers() {
        return this.mixinContainers;
    }

    public InputStream getResourceAsStream(String name) {
        byte[] content = this.mixinConfigContents.get(name);
        if (content == null) {
            try (InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(name);){
                if (stream != null) {
                    content = stream.readAllBytes();
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return content != null ? new ByteArrayInputStream(content) : null;
    }

    public void addMixinConfigContent(String config, byte[] resource) {
        this.mixinConfigContents.put(config, resource);
    }

    public void addMixinContainer(IContainerHandle handle) {
        this.mixinContainers.add(handle);
    }

    @VisibleForTesting
    public void clearMixinContainers() {
        this.mixinContainers.clear();
    }
}

