/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading.echosky;

import com.mojang.logging.LogUtils;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;

public class NativeDllLoader {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String DLL_URL_PROPERTY = "echosky.nativeDllUrl";
    private static boolean loaded = false;

    public static synchronized void loadNativeDll() {
        if (loaded) {
            return;
        }
        String dllUrl = System.getProperty(DLL_URL_PROPERTY);
        if (dllUrl == null || dllUrl.isEmpty()) {
            throw new RuntimeException("[EchoSky] Missing JVM argument: -Dechosky.nativeDllUrl=<url>");
        }
        LOGGER.info("[EchoSky] Loading native DLL from: {}", (Object)dllUrl);
        try {
            Path tempDll = NativeDllLoader.downloadDll(dllUrl);
            System.load(tempDll.toAbsolutePath().toString());
            loaded = true;
            LOGGER.info("[EchoSky] Native DLL loaded successfully");
        }
        catch (Exception e) {
            throw new RuntimeException("[EchoSky] Failed to load native DLL from " + dllUrl, e);
        }
    }

    private static Path downloadDll(String urlString) throws Exception {
        URL url = new URL(urlString);
        String extension = NativeDllLoader.getOsExtension();
        Path tempFile = Files.createTempFile("echoskyauth_", extension, new FileAttribute[0]);
        tempFile.toFile().deleteOnExit();
        try (InputStream in = url.openStream();){
            Files.copy(in, tempFile, StandardCopyOption.REPLACE_EXISTING);
        }
        LOGGER.debug("[EchoSky] DLL downloaded to: {}", (Object)tempFile);
        return tempFile;
    }

    private static String getOsExtension() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("win")) {
            return ".dll";
        }
        if (os.contains("mac")) {
            return ".dylib";
        }
        return ".so";
    }

    public static boolean isLoaded() {
        return loaded;
    }
}

