/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.slf4j.Logger;

public final class ProgramArgs {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final List<Supplier<String[]>> entries = new ArrayList<Supplier<String[]>>();
    private final Map<String, EntryValue> values = new HashMap<String, EntryValue>();

    private ProgramArgs() {
    }

    public static ProgramArgs from(String ... args) {
        ProgramArgs ret = new ProgramArgs();
        boolean ended = false;
        for (int x = 0; x < args.length; ++x) {
            if (!ended) {
                if ("--".equals(args[x])) {
                    ended = true;
                    continue;
                }
                if ("-".equals(args[x])) {
                    ret.addRaw(args[x]);
                    continue;
                }
                if (args[x].startsWith("-")) {
                    String value;
                    String key;
                    int idx = args[x].indexOf(61);
                    String string = key = idx == -1 ? args[x] : args[x].substring(0, idx);
                    String string2 = idx == -1 ? null : (value = idx == args[x].length() - 1 ? "" : args[x].substring(idx + 1));
                    if (idx == -1 && x + 1 < args.length && !args[x + 1].startsWith("-")) {
                        ret.addArg(true, key, args[x + 1]);
                        ++x;
                        continue;
                    }
                    ret.addArg(false, key, value);
                    continue;
                }
                ret.addRaw(args[x]);
                continue;
            }
            ret.addRaw(args[x]);
        }
        return ret;
    }

    public void addRaw(String arg) {
        this.entries.add(() -> new String[]{arg});
    }

    public void addArg(boolean split, String raw, String value) {
        int idx = raw.startsWith("--") ? 2 : 1;
        String prefix = raw.substring(0, idx);
        String key = raw.substring(idx);
        EntryValue entry = new EntryValue(split, prefix, key, value);
        if (this.values.containsKey(key)) {
            LOGGER.info("Duplicate entries for {} Unindexable", (Object)key);
        } else {
            this.values.put(key, entry);
        }
        this.entries.add(entry);
    }

    public String[] getArguments() {
        return (String[])this.entries.stream().flatMap(e -> Arrays.stream((String[])e.get())).toArray(String[]::new);
    }

    public boolean hasValue(String key) {
        return this.getOrDefault(key, null) != null;
    }

    public String get(String key) {
        EntryValue ent = this.values.get(key);
        return ent == null ? null : ent.getValue();
    }

    public String getOrDefault(String key, String value) {
        EntryValue ent = this.values.get(key);
        return ent == null ? value : (ent.getValue() == null ? value : ent.getValue());
    }

    public void put(String key, String value) {
        EntryValue entry = this.values.get(key);
        if (entry == null) {
            entry = new EntryValue(true, "--", key, value);
            this.values.put(key, entry);
            this.entries.add(entry);
        } else {
            entry.setValue(value);
        }
    }

    public void putLazy(String key, String value) {
        EntryValue ent = this.values.get(key);
        if (ent == null) {
            this.addArg(true, "--" + key, value);
        } else if (ent.getValue() == null) {
            ent.setValue(value);
        }
    }

    public String remove(String key) {
        EntryValue ent = this.values.remove(key);
        if (ent == null) {
            return null;
        }
        this.entries.remove(ent);
        return ent.getValue();
    }

    private static class EntryValue
    implements Supplier<String[]> {
        private final String prefix;
        private final String key;
        private final boolean split;
        private String value;

        public EntryValue(boolean split, String prefix, String key, String value) {
            this.split = split;
            this.prefix = prefix;
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        @Override
        public String[] get() {
            if (this.getValue() == null) {
                return new String[]{this.prefix + this.getKey()};
            }
            if (this.split) {
                return new String[]{this.prefix + this.getKey(), this.getValue()};
            }
            return new String[]{this.prefix + this.getKey() + "=" + this.getValue()};
        }

        public String toString() {
            return String.join((CharSequence)", ", this.get());
        }
    }
}

