/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.config;

import java.nio.file.Path;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.LoadedConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.fml.loading.StringUtils;
import org.jetbrains.annotations.Nullable;

public final class ModConfig {
    private final Type type;
    private final IConfigSpec spec;
    private final String fileName;
    final ModContainer container;
    @Nullable
    LoadedConfig loadedConfig;
    final Lock lock;

    ModConfig(Type type, IConfigSpec spec, ModContainer container, String fileName, ReentrantLock lock) {
        this.type = type;
        this.spec = spec;
        this.fileName = fileName;
        this.container = container;
        this.lock = lock;
    }

    public Type getType() {
        return this.type;
    }

    public String getFileName() {
        return this.fileName;
    }

    public IConfigSpec getSpec() {
        return this.spec;
    }

    public String getModId() {
        return this.container.getModId();
    }

    @Nullable
    public IConfigSpec.ILoadedConfig getLoadedConfig() {
        return this.loadedConfig;
    }

    @Nullable
    public Path getFullPath() {
        return this.loadedConfig != null ? this.loadedConfig.path() : null;
    }

    void setConfig(@Nullable LoadedConfig loadedConfig, Function<ModConfig, ModConfigEvent> eventConstructor) {
        this.lock.lock();
        try {
            this.loadedConfig = loadedConfig;
            this.spec.acceptConfig(loadedConfig);
            this.container.acceptEvent(eventConstructor.apply(this));
        }
        finally {
            this.lock.unlock();
        }
    }

    public static enum Type {
        COMMON,
        CLIENT,
        SERVER,
        STARTUP;


        public String extension() {
            return StringUtils.toLowerCase(this.name());
        }
    }
}

