/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.classloading.transformation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.neoforged.fml.classloading.transformation.ClassProcessorSet;
import net.neoforged.neoforgespi.transformation.ClassProcessor;
import net.neoforged.neoforgespi.transformation.ClassProcessorIds;
import net.neoforged.neoforgespi.transformation.ProcessorName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class ClassTransformStatistics {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<ProcessorName, Integer> TRANSFORMS_BY_PROCESSOR = new ConcurrentHashMap<ProcessorName, Integer>();
    private static final Map<ProcessorName, Integer> POTENTIAL_BY_PROCESSOR = new ConcurrentHashMap<ProcessorName, Integer>();
    private static final AtomicInteger LOADED_CLASS_COUNT = new AtomicInteger(0);
    private static final AtomicInteger TRANSFORMED_CLASS_COUNT = new AtomicInteger(0);
    private static final AtomicInteger MIXIN_PARSED_CLASS_COUNT = new AtomicInteger(0);

    public static void incrementMixinParsedClasses() {
        MIXIN_PARSED_CLASS_COUNT.incrementAndGet();
    }

    static void incrementAskedForTransform(ClassProcessor processor) {
        if (!processor.name().equals(ClassProcessorIds.COMPUTING_FRAMES)) {
            POTENTIAL_BY_PROCESSOR.compute(processor.name(), (k, v) -> v == null ? 1 : v + 1);
        }
    }

    static void incrementTransforms(ClassProcessor processor) {
        if (!processor.name().equals(ClassProcessorIds.COMPUTING_FRAMES)) {
            TRANSFORMS_BY_PROCESSOR.compute(processor.name(), (k, v) -> v == null ? 1 : v + 1);
        }
    }

    static void incrementLoadedClasses() {
        LOADED_CLASS_COUNT.incrementAndGet();
    }

    static void incrementTransformedClasses() {
        TRANSFORMED_CLASS_COUNT.incrementAndGet();
    }

    @ApiStatus.Internal
    public static synchronized String getTransformationSummary() {
        int loaded = LOADED_CLASS_COUNT.get();
        int transformed = TRANSFORMED_CLASS_COUNT.get();
        double ratio = loaded == 0 ? 0.0 : (double)transformed / (double)loaded * 100.0;
        return String.format("%s/%s (%.2f%%)", transformed, loaded, ratio);
    }

    @ApiStatus.Internal
    public static String getMixinParsedClassesSummary() {
        return String.valueOf(MIXIN_PARSED_CLASS_COUNT.get());
    }

    @ApiStatus.Internal
    public static synchronized void logTransformationSummary() {
        LOGGER.debug("Transformed/total loaded classes: {} and {} parsed for mixin", (Object)ClassTransformStatistics.getTransformationSummary(), (Object)ClassTransformStatistics.getMixinParsedClassesSummary());
    }

    @ApiStatus.Internal
    public static synchronized void checkTransformationBehavior() {
        ArrayList<ProcessorName> keys = new ArrayList<ProcessorName>(TRANSFORMS_BY_PROCESSOR.keySet());
        keys.forEach(name -> {
            Integer actual = TRANSFORMS_BY_PROCESSOR.get(name);
            Integer potential = POTENTIAL_BY_PROCESSOR.get(name);
            double ratio = (double)actual.intValue() / (double)potential.intValue();
            if (ratio > 0.25) {
                if (name.equals(ClassProcessorIds.MIXIN)) {
                    LOGGER.error("Class processor {} transformed {}% of loaded class which is suspiciously high; this could be due to a mixin coprocessor attempting mass-ASM", name, (Object)String.format("%.2f", ratio * 100.0));
                } else {
                    LOGGER.error("Class processor {} transformed {}% of loaded class which is suspiciously high; it may be attempting mass-ASM. Please report this to the mod author.", name, (Object)String.format("%.2f", ratio * 100.0));
                }
            }
        });
    }

    @ApiStatus.Internal
    public static synchronized String computeCrashReportEntry(ClassProcessorSet classProcessorSet) {
        List<ClassProcessor> transforms = classProcessorSet.getSortedProcessors();
        record Entry(double ratio, String name) {
        }
        ArrayList<Entry> entries = new ArrayList<Entry>();
        for (ClassProcessor transform : transforms) {
            ProcessorName name = transform.name();
            Integer actual = TRANSFORMS_BY_PROCESSOR.get(name);
            Integer potential = POTENTIAL_BY_PROCESSOR.get(name);
            double ratio = actual == null || potential == null ? 0.0 : 100.0 * (double)actual.intValue() / (double)potential.intValue();
            entries.add(new Entry(ratio, (String)(classProcessorSet.isMarker(transform) ? String.valueOf(name) + " (marker)" : name.toString())));
        }
        return entries.stream().map(e -> String.format("%05.2f%%: %s", e.ratio, e.name)).collect(Collectors.joining("\n\t\t", "\n\t\t", ""));
    }
}

