/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.classloading.transformation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.neoforged.fml.classloading.transformation.ClassProcessorAuditSource;
import net.neoforged.neoforgespi.transformation.ClassProcessor;
import net.neoforged.neoforgespi.transformation.ProcessorName;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public class ClassProcessorAuditLog
implements ClassProcessorAuditSource {
    private final Map<String, List<TransformerActivity>> audit = new ConcurrentHashMap<String, List<TransformerActivity>>();

    @VisibleForTesting
    public void clear() {
        this.audit.clear();
    }

    TransformerActivity forClassProcessor(String clazz, ClassProcessor classProcessor) {
        List<TransformerActivity> activities = this.getTransformerActivities(clazz);
        TransformerActivity activity = new TransformerActivity(classProcessor.name());
        activities.add(activity);
        return activity;
    }

    private List<TransformerActivity> getTransformerActivities(String clazz) {
        return this.audit.computeIfAbsent(clazz, k -> new ArrayList());
    }

    @Override
    public String getAuditString(String clazz) {
        return this.audit.getOrDefault(clazz, Collections.emptyList()).stream().filter(TransformerActivity::shouldInclude).map(TransformerActivity::getActivityString).collect(Collectors.joining(","));
    }

    static final class TransformerActivity
    implements BiConsumer<String, String[]> {
        private final ProcessorName processorName;
        private final List<String> activities = new ArrayList<String>();
        private boolean include = false;

        private TransformerActivity(ProcessorName processorName) {
            this.processorName = processorName;
        }

        private boolean shouldInclude() {
            return this.include || !this.activities.isEmpty();
        }

        void rewrites() {
            this.include = true;
        }

        private String getActivityString() {
            return String.valueOf(this.processorName) + (String)(this.activities.isEmpty() ? "" : "[" + String.join((CharSequence)",", this.activities) + "]");
        }

        @Override
        public void accept(String activity, String ... context) {
            this.activities.add(activity + (String)(context.length == 0 ? "" : ":" + String.join((CharSequence)":", context)));
        }
    }
}

