/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.classloading;

import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReference;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.neoforged.fml.classloading.JarContentsModule;
import net.neoforged.fml.classloading.JarContentsModuleReference;

public final class JarContentsModuleFinder
implements ModuleFinder {
    private final Map<String, ModuleReference> jars;

    public JarContentsModuleFinder(Collection<JarContentsModule> jars) {
        this.jars = jars.stream().collect(Collectors.toMap(JarContentsModule::moduleName, sj -> new JarContentsModuleReference(sj.moduleDescriptor(), sj.contents())));
    }

    @Override
    public Optional<ModuleReference> find(String name) {
        return Optional.ofNullable(this.jars.get(name));
    }

    @Override
    public Set<ModuleReference> findAll() {
        return Set.copyOf(this.jars.values());
    }
}

