/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.earlydisplay.theme;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.MemoryUtil;

public final class NativeBuffer
implements AutoCloseable {
    private static final int MAX_SIZE = 100000000;
    private final ByteBuffer buffer;
    private final Consumer<ByteBuffer> deallocator;
    private final AtomicBoolean deallocated = new AtomicBoolean();

    public NativeBuffer(ByteBuffer buffer, Consumer<ByteBuffer> deallocator) {
        this.buffer = buffer;
        this.deallocator = deallocator;
    }

    public static NativeBuffer loadFromPath(Path path) throws IOException {
        try (SeekableByteChannel channel = Files.newByteChannel(path, new OpenOption[0]);){
            long size = channel.size();
            if (size > 100000000L) {
                throw new IOException("The resource " + String.valueOf(path) + " exceeds the maximum size of 100000000");
            }
            ByteBuffer buffer = ByteBuffer.allocateDirect((int)size).order(ByteOrder.nativeOrder());
            channel.read(buffer);
            buffer.flip();
            NativeBuffer nativeBuffer = new NativeBuffer(buffer, ignored -> {});
            return nativeBuffer;
        }
    }

    public static NativeBuffer loadFromClasspath(String path, @Nullable ClassLoader classLoader) throws IOException {
        URL resource;
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        if ((resource = classLoader.getResource(path)) == null) {
            throw new NoSuchFileException("Couldn't find theme resource " + path);
        }
        URLConnection connection = resource.openConnection();
        try (InputStream in = connection.getInputStream();){
            int read;
            int contentLengthHint = connection.getContentLength();
            if (contentLengthHint == -1) {
                contentLengthHint = 8192;
            }
            ByteBuffer buffer = MemoryUtil.memAlloc((int)contentLengthHint);
            byte[] tmp = new byte[8192];
            while ((read = in.read(tmp)) != -1) {
                if (buffer.remaining() < read) {
                    buffer = MemoryUtil.memRealloc((ByteBuffer)buffer, (int)(buffer.capacity() * 2));
                }
                buffer.put(tmp, 0, read);
            }
            buffer.flip();
            NativeBuffer nativeBuffer = new NativeBuffer(buffer, MemoryUtil::memFree);
            return nativeBuffer;
        }
    }

    public ByteBuffer buffer() {
        return this.buffer;
    }

    public byte[] toByteArray() {
        byte[] data = new byte[this.buffer.remaining()];
        this.buffer.get(data);
        this.buffer.position(0);
        return data;
    }

    @Override
    public void close() {
        if (this.deallocated.compareAndSet(false, true)) {
            this.deallocator.accept(this.buffer);
        }
    }
}

