/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.earlydisplay.theme;

import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.file.Path;
import java.util.Objects;
import net.neoforged.fml.earlydisplay.theme.NativeBuffer;
import net.neoforged.fml.earlydisplay.theme.ThemeResource;
import net.neoforged.fml.earlydisplay.theme.UncompressedImage;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.stb.STBImage;
import org.lwjgl.system.MemoryUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ImageLoader {
    private static final String BROKEN_TEXTURE_NAME = "broken texture";
    private static final int BROKEN_TEXTURE_DIMENSIONS = 16;
    static final Logger LOGGER = LoggerFactory.getLogger(ImageLoader.class);

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static UncompressedImage loadImage(ThemeResource resource, @Nullable Path externalThemeDirectory) {
        Exception exception2;
        UncompressedImage uncompressedImage;
        Result result = ImageLoader.tryLoadImage(resource, externalThemeDirectory);
        Objects.requireNonNull(result);
        Result result2 = result;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Result.Success.class, Result.Error.class}, (Object)result2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Result.Success success = (Result.Success)result2;
                try {
                    UncompressedImage uncompressedImage2;
                    UncompressedImage image;
                    uncompressedImage = image = (uncompressedImage2 = success.image());
                    return uncompressedImage;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            case 1: 
        }
        Result.Error error = (Result.Error)result2;
        {
            Exception exception;
            exception2 = exception = error.exception();
        }
        LOGGER.error("Failed to load theme image {}", (Object)resource, (Object)exception2);
        uncompressedImage = ImageLoader.createBrokenImage();
        return uncompressedImage;
    }

    public static Result tryLoadImage(ThemeResource resource, @Nullable Path externalThemeDirectory) {
        NativeBuffer buffer = resource.toNativeBuffer(externalThemeDirectory);
        try {
            Result result = ImageLoader.tryLoadImage(resource.toString(), resource, buffer);
            if (buffer != null) {
                buffer.close();
            }
            return result;
        }
        catch (Throwable throwable) {
            try {
                if (buffer != null) {
                    try {
                        buffer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                return new Result.Error(e);
            }
        }
    }

    public static Result tryLoadImage(String debugName, @Nullable ThemeResource source, NativeBuffer buffer) {
        try {
            ImageLoader.validateHeader(buffer.buffer().slice());
            int[] width = new int[1];
            int[] height = new int[1];
            int[] channels = new int[1];
            ByteBuffer decodedImage = STBImage.stbi_load_from_memory((ByteBuffer)buffer.buffer(), (int[])width, (int[])height, (int[])channels, (int)4);
            if (decodedImage == null) {
                throw new IOException("PNG decoding error");
            }
            return new Result.Success(new UncompressedImage(debugName, source, new NativeBuffer(decodedImage, STBImage::stbi_image_free), width[0], height[0]));
        }
        catch (Exception e) {
            return new Result.Error(e);
        }
    }

    private static void validateHeader(ByteBuffer buffer) throws IOException {
        ByteOrder byteorder = buffer.order();
        buffer.order(ByteOrder.BIG_ENDIAN);
        if (buffer.getLong(0) != -8552249625308161526L) {
            throw new IOException("Bad PNG Signature");
        }
        if (buffer.getInt(8) != 13) {
            throw new IOException("Bad length for IHDR chunk!");
        }
        if (buffer.getInt(12) != 1229472850) {
            throw new IOException("Bad type for IHDR chunk!");
        }
        buffer.order(byteorder);
    }

    private static UncompressedImage createBrokenImage() {
        ByteBuffer pixelData = MemoryUtil.memAlloc((int)1024);
        IntBuffer pixelBuffer = pixelData.asIntBuffer();
        for (int y = 0; y < 16; ++y) {
            for (int x = 0; x < 16; ++x) {
                if (x < 8 ^ y < 8) {
                    pixelBuffer.put(-524040);
                    continue;
                }
                pixelBuffer.put(-16777216);
            }
        }
        NativeBuffer nativeBuffer = new NativeBuffer(pixelData, MemoryUtil::memFree);
        return new UncompressedImage(BROKEN_TEXTURE_NAME, null, nativeBuffer, 16, 16);
    }

    private ImageLoader() {
    }

    public static sealed interface Result {

        public record Error(Exception exception) implements Result
        {
        }

        public record Success(UncompressedImage image) implements Result
        {
        }
    }
}

