/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.earlydisplay.render.elements;

import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.neoforged.fml.earlydisplay.render.MaterializedTheme;
import net.neoforged.fml.earlydisplay.render.RenderContext;
import net.neoforged.fml.earlydisplay.render.SimpleFont;
import net.neoforged.fml.earlydisplay.render.elements.RenderElement;
import net.neoforged.fml.earlydisplay.theme.elements.ThemeLabelElement;
import net.neoforged.fml.earlydisplay.util.Bounds;
import net.neoforged.fml.earlydisplay.util.Placeholders;
import net.neoforged.fml.earlydisplay.util.Size;

public class LabelElement
extends RenderElement {
    private final String originalText;
    private final Supplier<Map<String, String>> placeholderSupplier;

    public LabelElement(ThemeLabelElement element, MaterializedTheme theme, Supplier<Map<String, String>> placeholderSupplier) {
        super(element, theme);
        this.originalText = element.text();
        this.placeholderSupplier = placeholderSupplier;
    }

    @Override
    public void render(RenderContext context) {
        String text = Placeholders.resolve(this.originalText, this.placeholderSupplier.get());
        List<SimpleFont.DisplayText> texts = List.of(new SimpleFont.DisplayText(text, -1));
        Size intrinsicSize = LabelElement.getIntrinsicSize(texts, this.font);
        Bounds bounds = this.resolveBounds(context.availableWidth(), context.availableHeight(), intrinsicSize.width(), intrinsicSize.height());
        context.renderText(bounds.left(), bounds.top(), this.font, texts);
    }

    private static Size getIntrinsicSize(List<SimpleFont.DisplayText> texts, SimpleFont font) {
        Bounds bounds = new Bounds(0.0f, 0.0f, 0.0f, 0.0f);
        for (SimpleFont.DisplayText text : texts) {
            bounds = bounds.union(new Bounds(0.0f, bounds.bottom(), font.measureText(text.string())));
        }
        return new Size(bounds.width(), bounds.height());
    }
}

