/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.earlydisplay.error;

import java.util.ArrayList;
import java.util.List;
import net.neoforged.fml.earlydisplay.render.SimpleFont;

final class FormatHelper {
    static List<List<SimpleFont.DisplayText>> formatText(String text, int defaultColor) {
        ArrayList<List<SimpleFont.DisplayText>> lines = new ArrayList<List<SimpleFont.DisplayText>>();
        ArrayList<SimpleFont.DisplayText> parts = new ArrayList<SimpleFont.DisplayText>();
        int lastIndex = 0;
        int lastColor = defaultColor;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\u00a7') {
                parts.add(FormatHelper.part(text, lastIndex, i, lastColor));
                lastIndex = i + 2;
                lastColor = FormatHelper.getColor(text.charAt(i + 1), lastColor, defaultColor);
                continue;
            }
            if (c != '\n') continue;
            parts.add(FormatHelper.part(text, lastIndex, i, lastColor));
            lines.add(parts);
            parts = new ArrayList();
            lastIndex = i + 1;
        }
        if (lastIndex < text.length() - 1) {
            parts.add(FormatHelper.part(text, lastIndex, text.length(), lastColor));
        }
        if (!parts.isEmpty()) {
            lines.add(parts);
        }
        return lines;
    }

    private static SimpleFont.DisplayText part(String text, int start, int end, int color) {
        return new SimpleFont.DisplayText(text.substring(start, end), color);
    }

    private static int getColor(char code, int lastColor, int defaultColor) {
        return switch (code) {
            case '0' -> -16777216;
            case '1' -> -16777046;
            case '2' -> -16733696;
            case '3' -> -16733526;
            case '4' -> -5636096;
            case '5' -> -5635926;
            case '6' -> -22016;
            case '7' -> -5592406;
            case '8' -> -11184811;
            case '9' -> -11184641;
            case 'a' -> -11141291;
            case 'b' -> -11141121;
            case 'c' -> -43691;
            case 'd' -> -43521;
            case 'e' -> -171;
            case 'f' -> -1;
            case 'r' -> defaultColor;
            default -> lastColor;
        };
    }

    private FormatHelper() {
    }
}

