/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.earlydisplay.error;

import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.List;
import java.util.Objects;
import net.neoforged.fml.earlydisplay.error.ErrorDisplayWindow;
import net.neoforged.fml.earlydisplay.render.RenderContext;
import net.neoforged.fml.earlydisplay.render.SimpleFont;
import net.neoforged.fml.earlydisplay.render.Texture;
import net.neoforged.fml.earlydisplay.theme.ImageLoader;
import net.neoforged.fml.earlydisplay.theme.NativeBuffer;
import net.neoforged.fml.earlydisplay.theme.TextureScaling;
import net.neoforged.fml.earlydisplay.theme.UncompressedImage;
import org.lwjgl.system.MemoryUtil;

final class Button {
    private final ErrorDisplayWindow window;
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private final String text;
    final Runnable onPress;
    private boolean focused;

    Button(ErrorDisplayWindow window, int x, int y, int width, int height, String text, Runnable onPress) {
        this.window = window;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.text = text;
        this.onPress = onPress;
    }

    void render(RenderContext ctx, SimpleFont font, double mouseX, double mouseY) {
        boolean highlighted = this.focused || this.isMouseOver(mouseX, mouseY);
        Texture texture = highlighted ? this.window.buttonTextureHover : this.window.buttonTexture;
        ctx.blitTexture(texture, this.x, this.y, this.width, this.height);
        int w = font.stringWidth(this.text);
        float tx = (float)this.x + (float)this.width / 2.0f - (float)w / 2.0f;
        ctx.renderTextWithShadow(tx, this.y + 2, font, List.of(new SimpleFont.DisplayText(this.text, -1)));
    }

    boolean isMouseOver(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseX < (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY < (double)(this.y + this.height);
    }

    boolean isFocused() {
        return this.focused;
    }

    void focus() {
        this.focused = true;
    }

    void unfocus() {
        this.focused = false;
    }

    static Texture loadTexture(boolean highlighted) {
        Texture texture;
        String suffix = highlighted ? "_highlighted" : "";
        String fileName = "assets/minecraft/textures/gui/sprites/widget/button" + suffix + ".png";
        String debugName = "error_button" + suffix;
        try {
            ImageLoader.Result result;
            NativeBuffer buffer = NativeBuffer.loadFromClasspath(fileName, null);
            ImageLoader.Result result2 = result = ImageLoader.tryLoadImage(debugName, null, buffer);
            Objects.requireNonNull(result2);
            ImageLoader.Result result3 = result2;
            int n = 0;
            texture = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ImageLoader.Result.Success.class, ImageLoader.Result.Error.class}, (Object)result3, n)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    ImageLoader.Result.Success success = (ImageLoader.Result.Success)result3;
                    TextureScaling.NineSlice scaling = new TextureScaling.NineSlice(400, 40, 6, 6, 6, 6, false, false, false);
                    yield Texture.create(success.image(), debugName, scaling, null);
                }
                case 1 -> {
                    ImageLoader.Result.Error ignored = (ImageLoader.Result.Error)result3;
                    yield Button.createFallbackTexture(highlighted, suffix);
                }
            };
        }
        catch (IOException e) {
            texture = Button.createFallbackTexture(highlighted, suffix);
        }
        return texture;
    }

    private static Texture createFallbackTexture(boolean highlighted, String suffix) {
        String name = "error_button_fallback" + suffix;
        int width = 60;
        int height = 20;
        ByteBuffer pixelData = MemoryUtil.memAlloc((int)(width * height * 4));
        IntBuffer pixelBuffer = pixelData.asIntBuffer();
        int borderColor = highlighted ? -1 : -16777216;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if (y == 0 || y == height - 1 || x == 0 || x == width - 1) {
                    pixelBuffer.put(borderColor);
                    continue;
                }
                pixelBuffer.put(-7829368);
            }
        }
        NativeBuffer buffer = new NativeBuffer(pixelData, MemoryUtil::memFree);
        UncompressedImage image = new UncompressedImage(name, null, buffer, width, height);
        TextureScaling.NineSlice scaling = new TextureScaling.NineSlice(width, height, 1, 1, 1, 1, true, true, false);
        return Texture.create(image, name, scaling, null);
    }
}

