/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.earlydisplay;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.time.Month;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import net.neoforged.fml.ModLoadingIssue;
import net.neoforged.fml.earlydisplay.error.ErrorDisplay;
import net.neoforged.fml.earlydisplay.render.LoadingScreenRenderer;
import net.neoforged.fml.earlydisplay.theme.Theme;
import net.neoforged.fml.earlydisplay.theme.ThemeLoader;
import net.neoforged.fml.earlydisplay.theme.UncompressedImage;
import net.neoforged.fml.loading.FMLConfig;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.fml.loading.ProgramArgs;
import net.neoforged.fml.loading.progress.ProgressMeter;
import net.neoforged.fml.loading.progress.StartupNotificationManager;
import net.neoforged.neoforgespi.earlywindow.ImmediateWindowProvider;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.opengl.GL;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.util.tinyfd.TinyFileDialogs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisplayWindow
implements ImmediateWindowProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"EARLYDISPLAY");
    private static final ThreadGroup BACKGROUND_THREAD_GROUP = new ThreadGroup("fml-loadingscreen");
    private final ProgressMeter mainProgress;
    private boolean darkMode;
    private Theme theme;
    private ScheduledFuture<LoadingScreenRenderer> rendererFuture;
    private long window;
    private ScheduledExecutorService renderScheduler;
    private int winWidth;
    private int winHeight;
    @Nullable
    private String assetsDir;
    @Nullable
    private String assetIndex;
    private boolean maximized;
    private Runnable repaintTick = () -> {};
    private volatile boolean closed;
    private String neoForgeVersion;
    private String minecraftVersion;
    private static final String ERROR_URL = "https://links.neoforged.net/early-display-errors";
    private final ReentrantLock crashLock = new ReentrantLock();

    public DisplayWindow() {
        this.mainProgress = StartupNotificationManager.addProgressBar((String)"", (int)0);
    }

    public String name() {
        return "fmlearlywindow";
    }

    public void initialize(ProgramArgs arguments) {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec widthopt = parser.accepts("width").withRequiredArg().ofType(Integer.class).defaultsTo((Object)FMLConfig.getIntConfigValue((FMLConfig.ConfigValue)FMLConfig.ConfigValue.EARLY_WINDOW_WIDTH), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec heightopt = parser.accepts("height").withRequiredArg().ofType(Integer.class).defaultsTo((Object)FMLConfig.getIntConfigValue((FMLConfig.ConfigValue)FMLConfig.ConfigValue.EARLY_WINDOW_HEIGHT), (Object[])new Integer[0]);
        OptionSpecBuilder maximizedopt = parser.accepts("earlywindow.maximized");
        ArgumentAcceptingOptionSpec assetsDirOpt = parser.accepts("assetsDir").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec assetIndexOpt = parser.accepts("assetIndex").withRequiredArg().ofType(String.class);
        parser.allowsUnrecognizedOptions();
        OptionSet parsed = parser.parse(arguments.getArguments());
        this.winWidth = (Integer)parsed.valueOf((OptionSpec)widthopt);
        this.winHeight = (Integer)parsed.valueOf((OptionSpec)heightopt);
        FMLConfig.updateConfig((FMLConfig.ConfigValue)FMLConfig.ConfigValue.EARLY_WINDOW_WIDTH, (Object)this.winWidth);
        FMLConfig.updateConfig((FMLConfig.ConfigValue)FMLConfig.ConfigValue.EARLY_WINDOW_HEIGHT, (Object)this.winHeight);
        if (parsed.has((OptionSpec)assetsDirOpt) && parsed.has((OptionSpec)assetIndexOpt)) {
            this.assetsDir = (String)parsed.valueOf((OptionSpec)assetsDirOpt);
            this.assetIndex = (String)parsed.valueOf((OptionSpec)assetIndexOpt);
        }
        if (Boolean.getBoolean("fml.earlyWindowDarkMode")) {
            this.darkMode = true;
        } else {
            try {
                List<String> optionLines = Files.readAllLines(FMLPaths.GAMEDIR.get().resolve(Paths.get("options.txt", new String[0])));
                Map<String, String> options = optionLines.stream().map(l -> l.split(":")).filter(a -> ((String[])a).length == 2).collect(Collectors.toMap(a -> a[0], a -> a[1]));
                this.darkMode = Boolean.parseBoolean(options.getOrDefault("darkMojangStudiosBackground", "false"));
            }
            catch (NoSuchFileException optionLines) {
            }
            catch (IOException e2) {
                LOGGER.warn("Failed to read dark-mode settings from options.txt", (Throwable)e2);
            }
        }
        String forcedTheme = FMLConfig.getConfigValue((FMLConfig.ConfigValue)FMLConfig.ConfigValue.EARLY_LOADING_SCREEN_THEME);
        if (!forcedTheme.isEmpty()) {
            LOGGER.info("Trying to load configured early loading screen theme '{}'", (Object)forcedTheme);
            this.theme = DisplayWindow.loadTheme(forcedTheme);
        } else {
            this.theme = DisplayWindow.loadTheme(this.darkMode);
        }
        this.maximized = parsed.has((OptionSpec)maximizedopt) || FMLConfig.getBoolConfigValue((FMLConfig.ConfigValue)FMLConfig.ConfigValue.EARLY_WINDOW_MAXIMIZED);
        this.renderScheduler = Executors.newSingleThreadScheduledExecutor(Thread.ofPlatform().group(BACKGROUND_THREAD_GROUP).name("fml-loadingscreen").daemon().uncaughtExceptionHandler((t, e) -> {
            System.err.println("Uncaught error on background rendering thread: " + String.valueOf(e));
            e.printStackTrace();
        }).factory());
        this.initWindow();
        this.rendererFuture = this.renderScheduler.schedule(() -> new LoadingScreenRenderer(this.renderScheduler, this.window, this.theme, DisplayWindow.getThemePath(), () -> this.minecraftVersion, () -> this.neoForgeVersion), 1L, TimeUnit.MILLISECONDS);
        this.updateProgress("Initializing Game Graphics");
    }

    public void setMinecraftVersion(String version) {
        this.minecraftVersion = version;
    }

    public void setNeoForgeVersion(String version) {
        if (!Objects.equals(this.neoForgeVersion, version)) {
            this.neoForgeVersion = version;
            StartupNotificationManager.modLoaderConsumer().ifPresent(c -> c.accept("Starting NeoForge " + version));
        }
    }

    private static Theme loadTheme(boolean darkMode) {
        return DisplayWindow.loadTheme(DisplayWindow.getThemeId(darkMode));
    }

    private static Theme loadTheme(String themeId) {
        Theme theme;
        Path themePath = DisplayWindow.getThemePath();
        try {
            theme = ThemeLoader.load(themePath, themeId);
        }
        catch (Exception e) {
            LOGGER.error("Failed to load theme {} from {}", new Object[]{themeId, themePath, e});
            theme = Theme.createDefaultTheme();
        }
        return theme;
    }

    private static String getThemeId(boolean darkMode) {
        String themeId = darkMode ? "darkmode" : "default";
        LocalDate today = LocalDate.now();
        if (today.getMonth() == Month.APRIL && today.getDayOfMonth() == 1) {
            themeId = darkMode ? "april-fools-darkmode" : "april-fools";
        }
        return themeId;
    }

    private static Path getThemePath() {
        return FMLPaths.CONFIGDIR.get().resolve("fml");
    }

    public void renderToFramebuffer() {
        if (this.rendererFuture.isDone()) {
            ((LoadingScreenRenderer)this.rendererFuture.resultNow()).renderToFramebuffer();
        }
    }

    private void crashElegantly(String errorDetails) {
        this.crashLock.lock();
        StringBuilder msgBuilder = new StringBuilder(2000);
        msgBuilder.append("Failed to initialize the mod loading system and display.\n");
        msgBuilder.append("\n\n");
        msgBuilder.append("Failure details:\n");
        msgBuilder.append(errorDetails);
        msgBuilder.append("\n\n");
        msgBuilder.append("If you click yes, we will try and open https://links.neoforged.net/early-display-errors in your default browser");
        LOGGER.error("ERROR DISPLAY\n{}", (Object)msgBuilder);
        Thread thread = new Thread(() -> {
            boolean res = TinyFileDialogs.tinyfd_messageBox((CharSequence)"Minecraft: NeoForge", (CharSequence)msgBuilder.toString(), (CharSequence)"yesno", (CharSequence)"error", (boolean)false);
            if (res) {
                try {
                    Desktop.getDesktop().browse(URI.create(ERROR_URL));
                }
                catch (IOException ioe) {
                    TinyFileDialogs.tinyfd_messageBox((CharSequence)"Minecraft: NeoForge", (CharSequence)"Sadly, we couldn't open your browser.\nVisit https://links.neoforged.net/early-display-errors", (CharSequence)"ok", (CharSequence)"error", (boolean)false);
                }
            }
        }, "crash-report");
        thread.setDaemon(true);
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.exit(1);
    }

    public void initWindow() {
        long primaryMonitor;
        long glfwInitBegin = System.nanoTime();
        if (!GLFW.glfwInit()) {
            this.crashElegantly("We are unable to initialize the graphics system.\nglfwInit failed.\n");
            throw new IllegalStateException("Unable to initialize GLFW");
        }
        long glfwInitEnd = System.nanoTime();
        if ((double)(glfwInitEnd - glfwInitBegin) > 1.0E9) {
            LOGGER.error("WARNING : glfwInit took {} seconds to start.", (Object)((double)(glfwInitEnd - glfwInitBegin) / 1.0E9));
        }
        DisplayWindow.getLastGlfwError().ifPresent(error -> LOGGER.error("Suppressing Last GLFW error: {}", error));
        GLFW.glfwDefaultWindowHints();
        GLFW.glfwWindowHint((int)139265, (int)196609);
        GLFW.glfwWindowHint((int)139275, (int)221185);
        GLFW.glfwWindowHint((int)139266, (int)3);
        GLFW.glfwWindowHint((int)139267, (int)3);
        GLFW.glfwWindowHint((int)139272, (int)204801);
        GLFW.glfwWindowHint((int)139270, (int)1);
        GLFW.glfwWindowHint((int)131076, (int)0);
        GLFW.glfwWindowHint((int)131075, (int)1);
        String vanillaWindowTitle = "Minecraft*";
        GLFW.glfwWindowHintString((int)147457, (CharSequence)vanillaWindowTitle);
        GLFW.glfwWindowHintString((int)147458, (CharSequence)vanillaWindowTitle);
        if (FMLConfig.getBoolConfigValue((FMLConfig.ConfigValue)FMLConfig.ConfigValue.DEBUG_OPENGL)) {
            LOGGER.info("Requesting the creation of an OpenGL debug context");
            GLFW.glfwWindowHint((int)139271, (int)1);
        }
        if ((primaryMonitor = GLFW.glfwGetPrimaryMonitor()) == 0L) {
            LOGGER.error("Failed to find a primary monitor - this means LWJGL isn't working properly");
            this.crashElegantly("Failed to locate a primary monitor.\nglfwGetPrimaryMonitor failed.\n");
            throw new IllegalStateException("Can't find a primary monitor");
        }
        GLFWVidMode vidmode = GLFW.glfwGetVideoMode((long)primaryMonitor);
        if (vidmode == null) {
            LOGGER.error("Failed to get the current display video mode.");
            this.crashElegantly("Failed to get current display resolution.\nglfwGetVideoMode failed.\n");
            throw new IllegalStateException("Can't get a resolution");
        }
        AtomicBoolean successfulWindow = new AtomicBoolean(false);
        ScheduledFuture<?> windowFailFuture = this.renderScheduler.schedule(() -> {
            if (!successfulWindow.get()) {
                this.crashElegantly("Timed out trying to setup the Game Window.");
            }
        }, 30L, TimeUnit.SECONDS);
        this.window = GLFW.glfwCreateWindow((int)this.winWidth, (int)this.winHeight, (CharSequence)"Minecraft: NeoForge Loading...", (long)0L, (long)0L);
        String creationError = DisplayWindow.getLastGlfwError().orElse("unknown error");
        if (this.window == 0L) {
            LOGGER.error("Failed to create window: {}", (Object)creationError);
            this.crashElegantly("Failed to create a window:\n" + creationError);
            throw new IllegalStateException("Failed to create a window");
        }
        successfulWindow.set(true);
        if (!windowFailFuture.cancel(true)) {
            throw new IllegalStateException("We died but didn't somehow?");
        }
        int[] x = new int[1];
        int[] y = new int[1];
        GLFW.glfwGetMonitorPos((long)primaryMonitor, (int[])x, (int[])y);
        int monitorX = x[0];
        int monitorY = y[0];
        if (this.maximized) {
            GLFW.glfwMaximizeWindow((long)this.window);
        }
        GLFW.glfwGetWindowSize((long)this.window, (int[])x, (int[])y);
        this.winWidth = x[0];
        this.winHeight = y[0];
        GLFW.glfwSetWindowPos((long)this.window, (int)((vidmode.width() - this.winWidth) / 2 + monitorX), (int)((vidmode.height() - this.winHeight) / 2 + monitorY));
        try (GLFWImage.Buffer glfwImgBuffer = GLFWImage.malloc((int)1);
             GLFWImage glfwImages = GLFWImage.malloc();
             UncompressedImage icon = this.theme.windowIcon().loadAsImage(DisplayWindow.getThemePath());){
            glfwImgBuffer.put((Struct)glfwImages.set(icon.width(), icon.height(), icon.imageData()));
            glfwImgBuffer.flip();
            GLFW.glfwSetWindowIcon((long)this.window, (GLFWImage.Buffer)glfwImgBuffer);
        }
        catch (Exception e) {
            LOGGER.error("Failed to load NeoForged icon", (Throwable)e);
        }
        DisplayWindow.getLastGlfwError().ifPresent(error -> LOGGER.warn("Failed to set window icon: {}", error));
        GLFW.glfwSetWindowSizeCallback((long)this.window, this::winResize);
        GLFW.glfwShowWindow((long)this.window);
        DisplayWindow.getLastGlfwError().ifPresent(error -> LOGGER.warn("Failed to show and position window: {}", error));
        GLFW.glfwPollEvents();
    }

    private void winResize(long window, int width, int height) {
        if (window == this.window && width != 0 && height != 0) {
            this.winWidth = width;
            this.winHeight = height;
        }
    }

    private static Optional<String> getLastGlfwError() {
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            PointerBuffer pointerbuffer = memorystack.mallocPointer(1);
            int error = GLFW.glfwGetError((PointerBuffer)pointerbuffer);
            if (error != 0) {
                String description;
                long pDescription = pointerbuffer.get();
                String string = description = pDescription == 0L ? null : MemoryUtil.memUTF8((long)pDescription);
                if (description != null) {
                    Optional<String> optional = Optional.of(String.format(Locale.ROOT, "[0x%X] %s", error, description));
                    return optional;
                }
                Optional<String> optional = Optional.of(String.format(Locale.ROOT, "[0x%X]", error));
                return optional;
            }
        }
        return Optional.empty();
    }

    public long takeOverGlfwWindow() {
        LoadingScreenRenderer renderer;
        try {
            renderer = (LoadingScreenRenderer)this.rendererFuture.get(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (TimeoutException e) {
            DisplayWindow.dumpBackgroundThreadStack();
            this.crashElegantly("We seem to be having trouble initializing the window, waited for 30 seconds");
            return -1L;
        }
        this.updateProgress("Initializing Game Graphics");
        try {
            renderer.stopAutomaticRendering();
        }
        catch (TimeoutException e) {
            DisplayWindow.dumpBackgroundThreadStack();
            this.crashElegantly("Cannot hand over rendering to Minecraft! The background loading screen renderer seems stuck.");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.completeProgress();
        GLFW.glfwMakeContextCurrent((long)this.window);
        GLFW.glfwSwapInterval((int)0);
        GLFW.glfwSetWindowSizeCallback((long)this.window, null).close();
        this.repaintTick = renderer::renderToScreen;
        return this.window;
    }

    public int getFramebufferTextureId() {
        if (!this.rendererFuture.isDone()) {
            throw new IllegalStateException("Initialization of the renderer has not completed yet.");
        }
        return ((LoadingScreenRenderer)this.rendererFuture.resultNow()).getFramebufferTextureId();
    }

    public void periodicTick() {
        if (this.rendererFuture.state() == Future.State.FAILED) {
            throw new RuntimeException("Initialization of the loading screen failed.", this.rendererFuture.exceptionNow());
        }
        GLFW.glfwPollEvents();
        if (!this.closed) {
            this.repaintTick.run();
        }
    }

    public void updateProgress(String label) {
        this.mainProgress.label(label);
    }

    public void completeProgress() {
        this.mainProgress.complete();
    }

    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.renderScheduler.shutdown();
            try {
                ((LoadingScreenRenderer)this.rendererFuture.get()).close();
            }
            catch (ExecutionException e) {
                LOGGER.error("Cannot close renderer since it failed to initialize", (Throwable)e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void crash(String message) {
        this.crashElegantly(message);
    }

    public void displayFatalErrorAndExit(List<ModLoadingIssue> issues, Path modsFolder, Path logFile, Path crashReportFile) {
        long windowId = this.takeOverGlfwWindow();
        GL.createCapabilities();
        this.close();
        ErrorDisplay.fatal(windowId, this.assetsDir, this.assetIndex, issues, modsFolder, logFile, crashReportFile);
    }

    private static void dumpBackgroundThreadStack() {
        BACKGROUND_THREAD_GROUP.list();
    }
}

